/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.core.model;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.model.GitIndex;
import com.aptana.git.core.model.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GitIndexRefreshJob
extends Job {
    private static final long UPDATE_DELAY = 200L;
    private HashSet<IPath> fRequests;
    private GitIndex index;
    private AtomicBoolean refreshAll;

    public GitIndexRefreshJob(GitIndex index) {
        super(Messages.GitIndexRefreshJob_Name);
        EclipseUtil.setSystemForJob((Job)this);
        this.index = index;
        this.fRequests = new HashSet(3);
        this.refreshAll = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        MultiStatus errors = new MultiStatus("com.aptana.git.core", 1, Messages.GitIndexRefreshJob_ErrorMsg, null);
        try {
            monitor.beginTask("", -1);
            while (true) {
                IStatus status;
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (this.refreshAll.compareAndSet(true, false)) {
                    HashSet<IPath> hashSet = this.fRequests;
                    synchronized (hashSet) {
                        this.fRequests = new HashSet(3);
                    }
                    status = this.index.refresh(monitor);
                } else {
                    ArrayList<IPath> copy;
                    HashSet<IPath> hashSet = this.fRequests;
                    synchronized (hashSet) {
                        if (this.fRequests.isEmpty()) {
                            break;
                        }
                        copy = new ArrayList<IPath>(this.fRequests);
                        this.fRequests = new HashSet(3);
                    }
                    status = this.index.refresh(true, copy, monitor);
                }
                if (!status.isOK()) {
                    errors.merge(status);
                }
                Thread.yield();
            }
        }
        finally {
            monitor.done();
        }
        if (!errors.isOK()) {
            IdeLog.log((Plugin)GitPlugin.getDefault(), (IStatus)errors);
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldRun() {
        HashSet<IPath> hashSet = this.fRequests;
        synchronized (hashSet) {
            return this.refreshAll.get() || !this.fRequests.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Collection<IPath> paths) {
        if (CollectionsUtil.isEmpty(paths)) {
            return;
        }
        HashSet<IPath> hashSet = this.fRequests;
        synchronized (hashSet) {
            this.fRequests.addAll(paths);
        }
        this.schedule(200L);
    }

    public boolean belongsTo(Object family) {
        return family == this.index;
    }

    public void refreshAll() {
        this.refreshAll.set(true);
        this.schedule(200L);
    }
}

